% Identification intuition a la AGS (2017)
% This procedure creates table 6
clear

load ../../'Estimation Results'/Benchmark_Model.mat

AGS = (D * W * D') \ (D * W); % Elasticity of parameters to moments a la Andrews, Gentzkow, and Shapiro (2017, QJE)

% From derivatives to semi-elasticities:
AGS_scaled = AGS./repmat(parameters(13:17)', 1, size(D, 2));

% Table 6 - panel A
figure('name', 'Elasticity of parameters to moments', 'color', [1 1 1]);
imagesc(AGS_scaled')
clim = [floor(min(AGS_scaled(:))), ceil(max(AGS_scaled(:)))];
caxis(clim)
map1  = ones(100*abs(clim(1)), 1)*[1 0 0] +linspace(0, 1, 100*abs(clim(1)))'.^4 * ([1 1 1]-[1 0 0]);
map2  = ones(100*abs(clim(2)), 1)*[0 0 1] +linspace(0, 1, 100*abs(clim(2)))'.^4 * ([1 1 1]-[0 0 1]);
map   = [map1; flipud(map2)];
colormap(map)
colorbar('fontweight', 'bold', 'fontsize', 14)
set(gca, 'xtick', 0.5:1:size(AGS_scaled,1))
set(gca, 'ytick', 0.5:1:size(AGS_scaled,2))
grid on
set(gca, 'xticklabel', [], 'yticklabel', [])
yticklab = {'$\sigma^2(p)$'; '$\sigma^2(i_n)$'; '$\sigma^2(i_o)$'; '$\sigma^2(q_n)$'; ...
            '$\sigma^2(q_o)$'; '$\rho(p, i_n)$'; '$\rho(p,i_o)$'; '$\rho(p,q_n)$'; ...
            '$\rho(p,q_o)$'; '$\rho(i_n,q_n)$'; '$\rho(i_o,q_o)$'; '$\rho(i_n,i_o)$'; ...
            '$\rho(q_n,q_o)$'; '$\rho(i_n,q_o)$'; '$\rho(i_o,q_n)$'; ...
            '$\rho(p'',p)$'; '$\rho(i_n'',i_n)$'; '$\rho(i_o'',i_o)$'; ...
            '$\rho(q_n'',q_n)$'; '$\rho(q_o'',q_o)$'};

xticklab = {'$\epsilon$', '$\rho_1^A$', '$\rho_2^A$', ...
            '$\sigma^2_u$', '$\sigma^2_A$'};
        
for i = 1:length(yticklab)
    text(0.3-0.001,0.3+0.5+(i-1), ...
     yticklab{i},'horizontalalign','right', 'interpreter','latex', 'fontsize', 13)
end

for i = 1:length(xticklab)
    text(0.3+0.5+(i-1),length(yticklab)+1.2, ...
     xticklab{i}, 'interpreter','latex', 'fontsize', 15)
end  

for i = 1:size(AGS_scaled, 1)
    for j = 1:size(AGS_scaled, 2)
   
        if abs(AGS_scaled(i,j))<0.2*max(abs(AGS_scaled(:)))
            text(i, j, num2str(AGS_scaled(i, j), '%.2f'), 'horizontalalign','center', 'fontweight','bold')
        else
            text(i, j, num2str(AGS_scaled(i, j), '%.2f'), 'horizontalalign','center', 'color', 'w', 'fontweight','bold')
        end        
    end
end


print('../../Figures/Table_6_Panel_A','-dpng')


% Get elasticity of moments w.r.t. parameters
D_scaled = D.*repmat(parameters(13:17)', 1, size(D, 2));
figure('name', 'Elasticity of moments to parameters', 'color', [1 1 1]);
imagesc(D_scaled')

clim = [floor(min(D_scaled(:))), ceil(max(D_scaled(:)))];
caxis(clim)
map1  = ones(100*abs(clim(1)), 1)*[1 0 0] +linspace(0, 1, 100*abs(clim(1)))'.^4 * ([1 1 1]-[1 0 0]);
map2  = ones(100*abs(clim(2)), 1)*[0 0 1] +linspace(0, 1, 100*abs(clim(2)))'.^4 * ([1 1 1]-[0 0 1]);
map   = [map1; flipud(map2)];
colormap(map)

colorbar('fontweight', 'bold', 'fontsize', 14)
colorbar('fontweight', 'bold', 'fontsize', 14)
set(gca, 'xtick', 0.5:1:size(AGS_scaled,1))
set(gca, 'ytick', 0.5:1:size(AGS_scaled,2))
grid on
set(gca, 'xticklabel', [], 'yticklabel', [])

for i = 1:length(yticklab)
    text(0.3-0.001,0.3+0.5+(i-1), ...
     yticklab{i},'horizontalalign','right', 'interpreter','latex', 'fontsize', 13)
end

for i = 1:length(xticklab)
    text(0.3+0.5+(i-1),length(yticklab)+1.2, ...
     xticklab{i}, 'interpreter','latex', 'fontsize', 15)
end  

for i = 1:size(D_scaled, 1)
    for j = 1:size(D_scaled, 2)
   
        if (D_scaled(i,j))<0.2*max((D_scaled(:))) && (D_scaled(i,j))>0.3*min((D_scaled(:)))
            text(i, j, num2str(D_scaled(i, j), '%.2f'), 'horizontalalign','center', 'fontweight','bold')
        else
            text(i, j, num2str(D_scaled(i, j), '%.2f'), 'horizontalalign','center', 'color', 'w', 'fontweight','bold')
        end        
    end
end

print('../../Figures/Table_6_Panel_B','-dpng')
